import{s as Gn,f as In,o as Bn,n as tn}from"../chunks/scheduler.8c3d61f6.js";import{S as Zn,i as Vn,g as a,s as i,r as d,A as En,h as l,f as n,c as s,j as U,u as m,x as u,k as x,y as c,a as o,v as f,d as h,t as g,w as _}from"../chunks/index.da70eac4.js";import{D as Z}from"../chunks/Docstring.ee4b6913.js";import{C as $e}from"../chunks/CodeBlock.00a903b3.js";import{E as en}from"../chunks/ExampleCodeBlock.f7bd2c1f.js";import{H as $,E as Dn}from"../chunks/EditOnGithub.1e64e623.js";function An(V){let p,J="Examples:",M,b,w;return b=new $e({props:{code:"ZnJvbSUyMGRpZmZ1c2lvbnMlMjBpbXBvcnQlMjBXdWVyc3RjaGVuQ29tYmluZWRQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBXdWVyc3RjaGVuQ29tYmluZWRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyd2FycC1haSUyRld1ZXJzdGNoZW4lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUwQSUyMCUyMCUyMCUyMCUyMmN1ZGElMjIlMEEpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbWFnZSUyMG9mJTIwYSUyMHNoaWJhJTIwaW51JTJDJTIwZG9ubmluZyUyMGElMjBzcGFjZXN1aXQlMjBhbmQlMjBoZWxtZXQlMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusions <span class="hljs-keyword">import</span> WuerstchenCombinedPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = WuerstchenCombinedPipeline.from_pretrained(<span class="hljs-string">&quot;warp-ai/Wuerstchen&quot;</span>, torch_dtype=torch.float16).to(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt)`,wrap:!1}}),{c(){p=a("p"),p.textContent=J,M=i(),d(b.$$.fragment)},l(r){p=l(r,"P",{"data-svelte-h":!0}),u(p)!=="svelte-kvfsh7"&&(p.textContent=J),M=s(r),m(b.$$.fragment,r)},m(r,y){o(r,p,y),o(r,M,y),f(b,r,y),w=!0},p:tn,i(r){w||(h(b.$$.fragment,r),w=!0)},o(r){g(b.$$.fragment,r),w=!1},d(r){r&&(n(p),n(M)),_(b,r)}}}function Ln(V){let p,J="Examples:",M,b,w;return b=new $e({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUlMEElMEFwcmlvcl9waXBlJTIwJTNEJTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMndhcnAtYWklMkZ3dWVyc3RjaGVuLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmFuJTIwaW1hZ2UlMjBvZiUyMGElMjBzaGliYSUyMGludSUyQyUyMGRvbm5pbmclMjBhJTIwc3BhY2VzdWl0JTIwYW5kJTIwaGVsbWV0JTIyJTBBcHJpb3Jfb3V0cHV0JTIwJTNEJTIwcGlwZShwcm9tcHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> WuerstchenPriorPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prior_pipe = WuerstchenPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;warp-ai/wuerstchen-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prior_output = pipe(prompt)`,wrap:!1}}),{c(){p=a("p"),p.textContent=J,M=i(),d(b.$$.fragment)},l(r){p=l(r,"P",{"data-svelte-h":!0}),u(p)!=="svelte-kvfsh7"&&(p.textContent=J),M=s(r),m(b.$$.fragment,r)},m(r,y){o(r,p,y),o(r,M,y),f(b,r,y),w=!0},p:tn,i(r){w||(h(b.$$.fragment,r),w=!0)},o(r){g(b.$$.fragment,r),w=!1},d(r){r&&(n(p),n(M)),_(b,r)}}}function Xn(V){let p,J="Examples:",M,b,w;return b=new $e({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUlMkMlMjBXdWVyc3RjaGVuRGVjb2RlclBpcGVsaW5lJTBBJTBBcHJpb3JfcGlwZSUyMCUzRCUyMFd1ZXJzdGNoZW5QcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ3YXJwLWFpJTJGd3VlcnN0Y2hlbi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5fcGlwZSUyMCUzRCUyMFd1ZXJzdGNoZW5EZWNvZGVyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbiglMjJ3YXJwLWFpJTJGd3VlcnN0Y2hlbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTBBJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhbiUyMGltYWdlJTIwb2YlMjBhJTIwc2hpYmElMjBpbnUlMkMlMjBkb25uaW5nJTIwYSUyMHNwYWNlc3VpdCUyMGFuZCUyMGhlbG1ldCUyMiUwQXByaW9yX291dHB1dCUyMCUzRCUyMHBpcGUocHJvbXB0KSUwQWltYWdlcyUyMCUzRCUyMGdlbl9waXBlKHByaW9yX291dHB1dC5pbWFnZV9lbWJlZGRpbmdzJTJDJTIwcHJvbXB0JTNEcHJvbXB0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> WuerstchenPriorPipeline, WuerstchenDecoderPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prior_pipe = WuerstchenPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;warp-ai/wuerstchen-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_pipe = WuerstchenDecoderPipeline.from_pretrain(<span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>, torch_dtype=torch.float16).to(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prior_output = pipe(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>images = gen_pipe(prior_output.image_embeddings, prompt=prompt)`,wrap:!1}}),{c(){p=a("p"),p.textContent=J,M=i(),d(b.$$.fragment)},l(r){p=l(r,"P",{"data-svelte-h":!0}),u(p)!=="svelte-kvfsh7"&&(p.textContent=J),M=s(r),m(b.$$.fragment,r)},m(r,y){o(r,p,y),o(r,M,y),f(b,r,y),w=!0},p:tn,i(r){w||(h(b.$$.fragment,r),w=!0)},o(r){g(b.$$.fragment,r),w=!1},d(r){r&&(n(p),n(M)),_(b,r)}}}function Nn(V){let p,J,M,b,w,r,y,nn,He,R,on='<a href="https://huggingface.co/papers/2306.00637" rel="nofollow">Wuerstchen: An Efficient Architecture for Large-Scale Text-to-Image Diffusion Models</a> is by Pablo Pernias, Dominic Rampas, Mats L. Richter and Christopher Pal and Marc Aubreville.',Ye,Q,sn="The abstract from the paper is:",ze,q,rn="<em>We introduce Würstchen, a novel architecture for text-to-image synthesis that combines competitive performance with unprecedented cost-effectiveness for large-scale text-to-image diffusion models. A key contribution of our work is to develop a latent diffusion technique in which we learn a detailed but extremely compact semantic image representation used to guide the diffusion process. This highly compressed representation of an image provides much more detailed guidance compared to latent representations of language and this significantly reduces the computational requirements to achieve state-of-the-art results. Our approach also improves the quality of text-conditioned image generation based on our user preference study. The training requirements of our approach consists of 24,602 A100-GPU hours - compared to Stable Diffusion 2.1’s 200,000 GPU hours. Our approach also requires less training data to achieve these results. Furthermore, our compact latent representations allows us to perform inference over twice as fast, slashing the usual costs and carbon footprint of a state-of-the-art (SOTA) diffusion model significantly, without compromising the end performance. In a broader comparison against SOTA models our approach is substantially more efficient and compares favorably in terms of image quality. We believe that this work motivates more emphasis on the prioritization of both performance and computational accessibility.</em>",Fe,S,Oe,H,an='Würstchen is a diffusion model, whose text-conditional model works in a highly compressed latent space of images. Why is this important? Compressing data can reduce computational costs for both training and inference by magnitudes. Training on 1024x1024 images is way more expensive than training on 32x32. Usually, other works make use of a relatively small compression, in the range of 4x - 8x spatial compression. Würstchen takes this to an extreme. Through its novel design, we achieve a 42x spatial compression. This was unseen before because common methods fail to faithfully reconstruct detailed images after 16x spatial compression. Würstchen employs a two-stage compression, what we call Stage A and Stage B. Stage A is a VQGAN, and Stage B is a Diffusion Autoencoder (more details can be found in the <a href="https://huggingface.co/papers/2306.00637" rel="nofollow">paper</a>). A third model, Stage C, is learned in that highly compressed latent space. This training requires fractions of the compute used for current top-performing models, while also allowing cheaper and faster inference.',Ke,Y,et,z,ln="After the initial paper release, we have improved numerous things in the architecture, training and sampling, making Würstchen competitive to current state-of-the-art models in many ways. We are excited to release this new version together with Diffusers. Here is a list of the improvements.",tt,F,cn="<li>Higher resolution (1024x1024 up to 2048x2048)</li> <li>Faster inference</li> <li>Multi Aspect Resolution Sampling</li> <li>Better quality</li>",nt,O,pn="We are releasing 3 checkpoints for the text-conditional image generation model (Stage C). Those are:",ot,K,dn="<li>v2-base</li> <li>v2-aesthetic</li> <li><strong>(default)</strong> v2-interpolated (50% interpolation between v2-base and v2-aesthetic)</li>",it,ee,mn=`We recommend using v2-interpolated, as it has a nice touch of both photorealism and aesthetics. Use v2-base for finetunings as it does not have a style bias and use v2-aesthetic for very artistic generations.
A comparison can be seen here:`,st,te,un,rt,ne,at,oe,fn="For the sake of usability, Würstchen can be used with a single pipeline. This pipeline can be used as follows:",lt,ie,ct,se,hn='For explanation purposes, we can also initialize the two main pipelines of Würstchen individually. Würstchen consists of 3 stages: Stage C, Stage B, Stage A. They all have different jobs and work only together. When generating text-conditional images, Stage C will first generate the latents in a very compressed latent space. This is what happens in the <code>prior_pipeline</code>. Afterwards, the generated latents will be passed to Stage B, which decompresses the latents into a bigger latent space of a VQGAN. These latents can then be decoded by Stage A, which is a VQGAN, into the pixel-space. Stage B &amp; Stage A are both encapsulated in the <code>decoder_pipeline</code>. For more details, take a look at the <a href="https://huggingface.co/papers/2306.00637" rel="nofollow">paper</a>.',pt,re,dt,ae,mt,le,gn="You can make use of <code>torch.compile</code> function and gain a speed-up of about 2-3x:",ut,ce,ft,pe,ht,de,_n=`<li>Due to the high compression employed by Würstchen, generations can lack a good amount
of detail. To our human eye, this is especially noticeable in faces, hands etc.</li> <li><strong>Images can only be generated in 128-pixel steps</strong>, e.g. the next higher resolution
after 1024x1024 is 1152x1152</li> <li>The model lacks the ability to render correct text in images</li> <li>The model often does not achieve photorealism</li> <li>Difficult compositional prompts are hard for the model</li>`,gt,me,bn='The original codebase, as well as experimental ideas, can be found at <a href="https://github.com/dome272/Wuerstchen" rel="nofollow">dome272/Wuerstchen</a>.',_t,ue,bt,v,fe,kt,je,wn="Combined Pipeline for text-to-image generation using Wuerstchen",It,ke,Mn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Gt,j,he,Bt,Ie,yn="Function invoked when calling the pipeline for generation.",Zt,E,Vt,D,ge,Et,Ge,vn=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Dt,A,_e,At,Be,Tn=`Offloads all models (<code>unet</code>, <code>text_encoder</code>, <code>vae</code>, and <code>safety checker</code> state dicts) to CPU using 🤗
Accelerate, significantly reducing memory usage. Models are moved to a <code>torch.device(&#39;meta&#39;)</code> and loaded on a
GPU only when their specific submodule’s <code>forward</code> method is called. Offloading happens on a submodule basis.
Memory savings are higher than using <code>enable_model_cpu_offload</code>, but performance is lower.`,wt,be,Mt,T,we,Lt,Ze,Wn="Pipeline for generating image prior for Wuerstchen.",Xt,Ve,xn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Nt,Ee,Jn="The pipeline also inherits the following loading methods:",Rt,De,Pn='<li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',Qt,k,Me,qt,Ae,Cn="Function invoked when calling the pipeline for generation.",St,L,yt,ye,vt,G,ve,Ht,Le,Un="Output class for WuerstchenPriorPipeline.",Tt,Te,Wt,P,We,Yt,Xe,$n="Pipeline for generating images from the Wuerstchen model.",zt,Ne,jn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ft,I,xe,Ot,Re,kn="Function invoked when calling the pipeline for generation.",Kt,X,xt,Je,Jt,Pe,Pt,Ce,Ct,Se,Ut;return w=new $({props:{title:"Würstchen",local:"würstchen",headingTag:"h1"}}),S=new $({props:{title:"Würstchen Overview",local:"würstchen-overview",headingTag:"h2"}}),Y=new $({props:{title:"Würstchen v2 comes to Diffusers",local:"würstchen-v2-comes-to-diffusers",headingTag:"h2"}}),ne=new $({props:{title:"Text-to-Image Generation",local:"text-to-image-generation",headingTag:"h2"}}),ie=new $e({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMucGlwZWxpbmVzLnd1ZXJzdGNoZW4lMjBpbXBvcnQlMjBERUZBVUxUX1NUQUdFX0NfVElNRVNURVBTJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMndhcnAtYWklMkZ3dWVyc3RjaGVuJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQWNhcHRpb24lMjAlM0QlMjAlMjJBbnRocm9wb21vcnBoaWMlMjBjYXQlMjBkcmVzc2VkJTIwYXMlMjBhJTIwZmlyZSUyMGZpZ2h0ZXIlMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGNhcHRpb24lMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxNTM2JTJDJTBBJTIwJTIwJTIwJTIwcHJpb3JfdGltZXN0ZXBzJTNEREVGQVVMVF9TVEFHRV9DX1RJTUVTVEVQUyUyQyUwQSUyMCUyMCUyMCUyMHByaW9yX2d1aWRhbmNlX3NjYWxlJTNENC4wJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMiUyQyUwQSkuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.pipelines.wuerstchen <span class="hljs-keyword">import</span> DEFAULT_STAGE_C_TIMESTEPS

pipe = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

caption = <span class="hljs-string">&quot;Anthropomorphic cat dressed as a fire fighter&quot;</span>
images = pipe(
    caption,
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1536</span>,
    prior_timesteps=DEFAULT_STAGE_C_TIMESTEPS,
    prior_guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=<span class="hljs-number">2</span>,
).images`,wrap:!1}}),re=new $e({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwV3VlcnN0Y2hlbkRlY29kZXJQaXBlbGluZSUyQyUyMFd1ZXJzdGNoZW5QcmlvclBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMud3VlcnN0Y2hlbiUyMGltcG9ydCUyMERFRkFVTFRfU1RBR0VfQ19USU1FU1RFUFMlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBZHR5cGUlMjAlM0QlMjB0b3JjaC5mbG9hdDE2JTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMiUwQSUwQXByaW9yX3BpcGVsaW5lJTIwJTNEJTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMndhcnAtYWklMkZ3dWVyc3RjaGVuLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0RkdHlwZSUwQSkudG8oZGV2aWNlKSUwQWRlY29kZXJfcGlwZWxpbmUlMjAlM0QlMjBXdWVyc3RjaGVuRGVjb2RlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ3YXJwLWFpJTJGd3VlcnN0Y2hlbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEZHR5cGUlMEEpLnRvKGRldmljZSklMEElMEFjYXB0aW9uJTIwJTNEJTIwJTIyQW50aHJvcG9tb3JwaGljJTIwY2F0JTIwZHJlc3NlZCUyMGFzJTIwYSUyMGZpcmUlMjBmaWdodGVyJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTBBJTBBcHJpb3Jfb3V0cHV0JTIwJTNEJTIwcHJpb3JfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEY2FwdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDE1MzYlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcHMlM0RERUZBVUxUX1NUQUdFX0NfVElNRVNURVBTJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q0LjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzX3Blcl9wcm9tcHQlMkMlMEEpJTBBZGVjb2Rlcl9vdXRwdXQlMjAlM0QlMjBkZWNvZGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkZGluZ3MlM0Rwcmlvcl9vdXRwdXQuaW1hZ2VfZW1iZWRkaW5ncyUyQyUwQSUyMCUyMCUyMCUyMHByb21wdCUzRGNhcHRpb24lMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTNEJTIycGlsJTIyJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBZGVjb2Rlcl9vdXRwdXQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> WuerstchenDecoderPipeline, WuerstchenPriorPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.wuerstchen <span class="hljs-keyword">import</span> DEFAULT_STAGE_C_TIMESTEPS

device = <span class="hljs-string">&quot;cuda&quot;</span>
dtype = torch.float16
num_images_per_prompt = <span class="hljs-number">2</span>

prior_pipeline = WuerstchenPriorPipeline.from_pretrained(
    <span class="hljs-string">&quot;warp-ai/wuerstchen-prior&quot;</span>, torch_dtype=dtype
).to(device)
decoder_pipeline = WuerstchenDecoderPipeline.from_pretrained(
    <span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>, torch_dtype=dtype
).to(device)

caption = <span class="hljs-string">&quot;Anthropomorphic cat dressed as a fire fighter&quot;</span>
negative_prompt = <span class="hljs-string">&quot;&quot;</span>

prior_output = prior_pipeline(
    prompt=caption,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1536</span>,
    timesteps=DEFAULT_STAGE_C_TIMESTEPS,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=num_images_per_prompt,
)
decoder_output = decoder_pipeline(
    image_embeddings=prior_output.image_embeddings,
    prompt=caption,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">0.0</span>,
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
).images[<span class="hljs-number">0</span>]
decoder_output`,wrap:!1}}),ae=new $({props:{title:"Speed-Up Inference",local:"speed-up-inference",headingTag:"h2"}}),ce=new $e({props:{code:"cHJpb3JfcGlwZWxpbmUucHJpb3IlMjAlM0QlMjB0b3JjaC5jb21waWxlKHByaW9yX3BpcGVsaW5lLnByaW9yJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBZGVjb2Rlcl9waXBlbGluZS5kZWNvZGVyJTIwJTNEJTIwdG9yY2guY29tcGlsZShkZWNvZGVyX3BpcGVsaW5lLmRlY29kZXIlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:`prior_pipeline.prior = torch.<span class="hljs-built_in">compile</span>(prior_pipeline.prior, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
decoder_pipeline.decoder = torch.<span class="hljs-built_in">compile</span>(decoder_pipeline.decoder, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),pe=new $({props:{title:"Limitations",local:"limitations",headingTag:"h2"}}),ue=new $({props:{title:"WuerstchenCombinedPipeline",local:"diffusers.WuerstchenCombinedPipeline",headingTag:"h2"}}),fe=new Z({props:{name:"class diffusers.WuerstchenCombinedPipeline",anchor:"diffusers.WuerstchenCombinedPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"decoder",val:": WuerstchenDiffNeXt"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"vqgan",val:": PaellaVQModel"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_text_encoder",val:": CLIPTextModel"},{name:"prior_prior",val:": WuerstchenPrior"},{name:"prior_scheduler",val:": DDPMWuerstchenScheduler"}],parametersDescription:[{anchor:"diffusers.WuerstchenCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
The decoder tokenizer to be used for text inputs.`,name:"tokenizer"},{anchor:"diffusers.WuerstchenCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The decoder text encoder to be used for text inputs.`,name:"text_encoder"},{anchor:"diffusers.WuerstchenCombinedPipeline.decoder",description:`<strong>decoder</strong> (<code>WuerstchenDiffNeXt</code>) &#x2014;
The decoder model to be used for decoder image generation pipeline.`,name:"decoder"},{anchor:"diffusers.WuerstchenCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
The scheduler to be used for decoder image generation pipeline.`,name:"scheduler"},{anchor:"diffusers.WuerstchenCombinedPipeline.vqgan",description:`<strong>vqgan</strong> (<code>PaellaVQModel</code>) &#x2014;
The VQGAN model to be used for decoder image generation pipeline.`,name:"vqgan"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
The prior tokenizer to be used for text inputs.`,name:"prior_tokenizer"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The prior text encoder to be used for text inputs.`,name:"prior_text_encoder"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<code>WuerstchenPrior</code>) &#x2014;
The prior model to be used for prior pipeline.`,name:"prior_prior"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
The scheduler to be used for prior pipeline.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L43"}}),he=new Z({props:{name:"__call__",anchor:"diffusers.WuerstchenCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_num_inference_steps",val:": int = 60"},{name:"prior_timesteps",val:": Optional = None"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"num_inference_steps",val:": int = 12"},{name:"decoder_timesteps",val:": Optional = None"},{name:"decoder_guidance_scale",val:": float = 0.0"},{name:"negative_prompt",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation for the prior and decoder.`,name:"prompt"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings for the prior. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings for the prior. Can be used to easily tweak text inputs, <em>e.g.</em>
prompt weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>prior_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>prior_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked
to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>Union[int, Dict[float, int]]</code>, <em>optional</em>, defaults to 60) &#x2014;
The number of prior denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. For more specific timestep spacing, you can pass customized
<code>prior_timesteps</code>`,name:"prior_num_inference_steps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The number of decoder denoising steps. More denoising steps usually lead to a higher quality image at
the expense of slower inference. For more specific timestep spacing, you can pass customized
<code>timesteps</code>`,name:"num_inference_steps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_timesteps",description:`<strong>prior_timesteps</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process for the prior. If not defined, equal spaced
<code>prior_num_inference_steps</code> timesteps are used. Must be in descending order.`,name:"prior_timesteps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.decoder_timesteps",description:`<strong>decoder_timesteps</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process for the decoder. If not defined, equal spaced
<code>num_inference_steps</code> timesteps are used. Must be in descending order.`,name:"decoder_timesteps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.decoder_guidance_scale",description:`<strong>decoder_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"decoder_guidance_scale"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L143",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code> <a
  href="/docs/diffusers/main/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> if <code>return_dict</code> is True,
otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`}}),E=new en({props:{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.example",$$slots:{default:[An]},$$scope:{ctx:V}}}),ge=new Z({props:{name:"enable_model_cpu_offload",anchor:"diffusers.WuerstchenCombinedPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L115"}}),_e=new Z({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.WuerstchenCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L125"}}),be=new $({props:{title:"WuerstchenPriorPipeline",local:"diffusers.WuerstchenPriorPipeline",headingTag:"h2"}}),we=new Z({props:{name:"class diffusers.WuerstchenPriorPipeline",anchor:"diffusers.WuerstchenPriorPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"prior",val:": WuerstchenPrior"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"latent_mean",val:": float = 42.0"},{name:"latent_std",val:": float = 1.0"},{name:"resolution_multiple",val:": float = 42.67"}],parametersDescription:[{anchor:"diffusers.WuerstchenPriorPipeline.prior",description:`<strong>prior</strong> (<code>Prior</code>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.WuerstchenPriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.WuerstchenPriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.WuerstchenPriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.WuerstchenPriorPipeline.latent_mean",description:`<strong>latent_mean</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to 42.0) &#x2014;
Mean value for latent diffusers.`,name:"latent_mean"},{anchor:"diffusers.WuerstchenPriorPipeline.latent_std",description:`<strong>latent_std</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to 1.0) &#x2014;
Standard value for latent diffusers.`,name:"latent_std"},{anchor:"diffusers.WuerstchenPriorPipeline.resolution_multiple",description:`<strong>resolution_multiple</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to 42.67) &#x2014;
Default resolution for multiple images generated.`,name:"resolution_multiple"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_prior.py#L65"}}),Me=new Z({props:{name:"__call__",anchor:"diffusers.WuerstchenPriorPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": int = 1024"},{name:"width",val:": int = 1024"},{name:"num_inference_steps",val:": int = 60"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 8.0"},{name:"negative_prompt",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.WuerstchenPriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 60) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps are used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 8.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>decoder_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>decoder_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely
linked to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>decoder_guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_prior.py#L281",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.WuerstchenPriorPipelineOutput</code> or <code>tuple</code> <code>~pipelines.WuerstchenPriorPipelineOutput</code> if
<code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the
generated image embeddings.</p>
`}}),L=new en({props:{anchor:"diffusers.WuerstchenPriorPipeline.__call__.example",$$slots:{default:[Ln]},$$scope:{ctx:V}}}),ye=new $({props:{title:"WuerstchenPriorPipelineOutput",local:"diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput",headingTag:"h2"}}),ve=new Z({props:{name:"class diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput",anchor:"diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput",parameters:[{name:"image_embeddings",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput.image_embeddings",description:`<strong>image_embeddings</strong> (<code>torch.Tensor</code> or <code>np.ndarray</code>) &#x2014;
Prior image embeddings for text prompt`,name:"image_embeddings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_prior.py#L51"}}),Te=new $({props:{title:"WuerstchenDecoderPipeline",local:"diffusers.WuerstchenDecoderPipeline",headingTag:"h2"}}),We=new Z({props:{name:"class diffusers.WuerstchenDecoderPipeline",anchor:"diffusers.WuerstchenDecoderPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"decoder",val:": WuerstchenDiffNeXt"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"vqgan",val:": PaellaVQModel"},{name:"latent_dim_scale",val:": float = 10.67"}],parametersDescription:[{anchor:"diffusers.WuerstchenDecoderPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
The CLIP tokenizer.`,name:"tokenizer"},{anchor:"diffusers.WuerstchenDecoderPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The CLIP text encoder.`,name:"text_encoder"},{anchor:"diffusers.WuerstchenDecoderPipeline.decoder",description:`<strong>decoder</strong> (<code>WuerstchenDiffNeXt</code>) &#x2014;
The WuerstchenDiffNeXt unet decoder.`,name:"decoder"},{anchor:"diffusers.WuerstchenDecoderPipeline.vqgan",description:`<strong>vqgan</strong> (<code>PaellaVQModel</code>) &#x2014;
The VQGAN model.`,name:"vqgan"},{anchor:"diffusers.WuerstchenDecoderPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.WuerstchenDecoderPipeline.latent_dim_scale",description:`<strong>latent_dim_scale</strong> (float, <code>optional</code>, defaults to 10.67) &#x2014;
Multiplier to determine the VQ latent space size from the image embeddings. If the image embeddings are
height=24 and width=24, the VQ latent shape needs to be height=int(24<em>10.67)=256 and
width=int(24</em>10.67)=256 in order to match the training conditions.`,name:"latent_dim_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen.py#L51"}}),xe=new Z({props:{name:"__call__",anchor:"diffusers.WuerstchenDecoderPipeline.__call__",parameters:[{name:"image_embeddings",val:": Union"},{name:"prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 12"},{name:"timesteps",val:": Optional = None"},{name:"guidance_scale",val:": float = 0.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.image_embedding",description:`<strong>image_embedding</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
Image Embeddings either extracted from an image or generated by a Prior Model.`,name:"image_embedding"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps are used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>decoder_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>decoder_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely
linked to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>decoder_guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen.py#L208",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code> <a
  href="/docs/diffusers/main/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> if <code>return_dict</code> is True,
otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated image
embeddings.</p>
`}}),X=new en({props:{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.example",$$slots:{default:[Xn]},$$scope:{ctx:V}}}),Je=new $({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Pe=new $e({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTQwbWlzYyU3QnBlcm5pYXMyMDIzd3VlcnN0Y2hlbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCV3VlcnN0Y2hlbiUzQSUyMEFuJTIwRWZmaWNpZW50JTIwQXJjaGl0ZWN0dXJlJTIwZm9yJTIwTGFyZ2UtU2NhbGUlMjBUZXh0LXRvLUltYWdlJTIwRGlmZnVzaW9uJTIwTW9kZWxzJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCUGFibG8lMjBQZXJuaWFzJTIwYW5kJTIwRG9taW5pYyUyMFJhbXBhcyUyMGFuZCUyME1hdHMlMjBMLiUyMFJpY2h0ZXIlMjBhbmQlMjBDaHJpc3RvcGhlciUyMEouJTIwUGFsJTIwYW5kJTIwTWFyYyUyMEF1YnJldmlsbGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjIzMDYuMDA2MzclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RA==",highlighted:`      @misc{pernias2023wuerstchen,
            title={Wuerstchen: An Efficient Architecture for Large-<span class="hljs-keyword">Scale </span>Text-to-Image <span class="hljs-keyword">Diffusion </span>Models},
            author={Pablo Pernias <span class="hljs-keyword">and </span>Dominic Rampas <span class="hljs-keyword">and </span>Mats L. Richter <span class="hljs-keyword">and </span>Christopher <span class="hljs-keyword">J. </span>Pal <span class="hljs-keyword">and </span>Marc Aubreville},
            year={<span class="hljs-number">2023</span>},
            eprint={<span class="hljs-number">2306</span>.<span class="hljs-number">00637</span>},
            archivePrefix={arXiv},
            primaryClass={cs.CV}
      }`,wrap:!1}}),Ce=new Dn({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/wuerstchen.md"}}),{c(){p=a("meta"),J=i(),M=a("p"),b=i(),d(w.$$.fragment),r=i(),y=a("img"),He=i(),R=a("p"),R.innerHTML=on,Ye=i(),Q=a("p"),Q.textContent=sn,ze=i(),q=a("p"),q.innerHTML=rn,Fe=i(),d(S.$$.fragment),Oe=i(),H=a("p"),H.innerHTML=an,Ke=i(),d(Y.$$.fragment),et=i(),z=a("p"),z.textContent=ln,tt=i(),F=a("ul"),F.innerHTML=cn,nt=i(),O=a("p"),O.textContent=pn,ot=i(),K=a("ul"),K.innerHTML=dn,it=i(),ee=a("p"),ee.textContent=mn,st=i(),te=a("img"),rt=i(),d(ne.$$.fragment),at=i(),oe=a("p"),oe.textContent=fn,lt=i(),d(ie.$$.fragment),ct=i(),se=a("p"),se.innerHTML=hn,pt=i(),d(re.$$.fragment),dt=i(),d(ae.$$.fragment),mt=i(),le=a("p"),le.innerHTML=gn,ut=i(),d(ce.$$.fragment),ft=i(),d(pe.$$.fragment),ht=i(),de=a("ul"),de.innerHTML=_n,gt=i(),me=a("p"),me.innerHTML=bn,_t=i(),d(ue.$$.fragment),bt=i(),v=a("div"),d(fe.$$.fragment),kt=i(),je=a("p"),je.textContent=wn,It=i(),ke=a("p"),ke.innerHTML=Mn,Gt=i(),j=a("div"),d(he.$$.fragment),Bt=i(),Ie=a("p"),Ie.textContent=yn,Zt=i(),d(E.$$.fragment),Vt=i(),D=a("div"),d(ge.$$.fragment),Et=i(),Ge=a("p"),Ge.innerHTML=vn,Dt=i(),A=a("div"),d(_e.$$.fragment),At=i(),Be=a("p"),Be.innerHTML=Tn,wt=i(),d(be.$$.fragment),Mt=i(),T=a("div"),d(we.$$.fragment),Lt=i(),Ze=a("p"),Ze.textContent=Wn,Xt=i(),Ve=a("p"),Ve.innerHTML=xn,Nt=i(),Ee=a("p"),Ee.textContent=Jn,Rt=i(),De=a("ul"),De.innerHTML=Pn,Qt=i(),k=a("div"),d(Me.$$.fragment),qt=i(),Ae=a("p"),Ae.textContent=Cn,St=i(),d(L.$$.fragment),yt=i(),d(ye.$$.fragment),vt=i(),G=a("div"),d(ve.$$.fragment),Ht=i(),Le=a("p"),Le.textContent=Un,Tt=i(),d(Te.$$.fragment),Wt=i(),P=a("div"),d(We.$$.fragment),Yt=i(),Xe=a("p"),Xe.textContent=$n,zt=i(),Ne=a("p"),Ne.innerHTML=jn,Ft=i(),I=a("div"),d(xe.$$.fragment),Ot=i(),Re=a("p"),Re.textContent=kn,Kt=i(),d(X.$$.fragment),xt=i(),d(Je.$$.fragment),Jt=i(),d(Pe.$$.fragment),Pt=i(),d(Ce.$$.fragment),Ct=i(),Se=a("p"),this.h()},l(e){const t=En("svelte-u9bgzb",document.head);p=l(t,"META",{name:!0,content:!0}),t.forEach(n),J=s(e),M=l(e,"P",{}),U(M).forEach(n),b=s(e),m(w.$$.fragment,e),r=s(e),y=l(e,"IMG",{src:!0}),He=s(e),R=l(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-hm8v9i"&&(R.innerHTML=on),Ye=s(e),Q=l(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1cwsb16"&&(Q.textContent=sn),ze=s(e),q=l(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-10ea9cr"&&(q.innerHTML=rn),Fe=s(e),m(S.$$.fragment,e),Oe=s(e),H=l(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1i2c2wf"&&(H.innerHTML=an),Ke=s(e),m(Y.$$.fragment,e),et=s(e),z=l(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-idonvk"&&(z.textContent=ln),tt=s(e),F=l(e,"UL",{"data-svelte-h":!0}),u(F)!=="svelte-hwtnnt"&&(F.innerHTML=cn),nt=s(e),O=l(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-bpk4lp"&&(O.textContent=pn),ot=s(e),K=l(e,"UL",{"data-svelte-h":!0}),u(K)!=="svelte-holqkq"&&(K.innerHTML=dn),it=s(e),ee=l(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-izmk3f"&&(ee.textContent=mn),st=s(e),te=l(e,"IMG",{src:!0,width:!0}),rt=s(e),m(ne.$$.fragment,e),at=s(e),oe=l(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-q6mitm"&&(oe.textContent=fn),lt=s(e),m(ie.$$.fragment,e),ct=s(e),se=l(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-16aw41o"&&(se.innerHTML=hn),pt=s(e),m(re.$$.fragment,e),dt=s(e),m(ae.$$.fragment,e),mt=s(e),le=l(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-13xqqkt"&&(le.innerHTML=gn),ut=s(e),m(ce.$$.fragment,e),ft=s(e),m(pe.$$.fragment,e),ht=s(e),de=l(e,"UL",{"data-svelte-h":!0}),u(de)!=="svelte-157ejdo"&&(de.innerHTML=_n),gt=s(e),me=l(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1674xah"&&(me.innerHTML=bn),_t=s(e),m(ue.$$.fragment,e),bt=s(e),v=l(e,"DIV",{class:!0});var W=U(v);m(fe.$$.fragment,W),kt=s(W),je=l(W,"P",{"data-svelte-h":!0}),u(je)!=="svelte-19cx0lp"&&(je.textContent=wn),It=s(W),ke=l(W,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-wu1jmh"&&(ke.innerHTML=Mn),Gt=s(W),j=l(W,"DIV",{class:!0});var B=U(j);m(he.$$.fragment,B),Bt=s(B),Ie=l(B,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-v78lg8"&&(Ie.textContent=yn),Zt=s(B),m(E.$$.fragment,B),B.forEach(n),Vt=s(W),D=l(W,"DIV",{class:!0});var Ue=U(D);m(ge.$$.fragment,Ue),Et=s(Ue),Ge=l(Ue,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-d7vywi"&&(Ge.innerHTML=vn),Ue.forEach(n),Dt=s(W),A=l(W,"DIV",{class:!0});var $t=U(A);m(_e.$$.fragment,$t),At=s($t),Be=l($t,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-a2a0wt"&&(Be.innerHTML=Tn),$t.forEach(n),W.forEach(n),wt=s(e),m(be.$$.fragment,e),Mt=s(e),T=l(e,"DIV",{class:!0});var C=U(T);m(we.$$.fragment,C),Lt=s(C),Ze=l(C,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1atgjon"&&(Ze.textContent=Wn),Xt=s(C),Ve=l(C,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-wu1jmh"&&(Ve.innerHTML=xn),Nt=s(C),Ee=l(C,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-14s6m4u"&&(Ee.textContent=Jn),Rt=s(C),De=l(C,"UL",{"data-svelte-h":!0}),u(De)!=="svelte-1uz0xyq"&&(De.innerHTML=Pn),Qt=s(C),k=l(C,"DIV",{class:!0});var Qe=U(k);m(Me.$$.fragment,Qe),qt=s(Qe),Ae=l(Qe,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-v78lg8"&&(Ae.textContent=Cn),St=s(Qe),m(L.$$.fragment,Qe),Qe.forEach(n),C.forEach(n),yt=s(e),m(ye.$$.fragment,e),vt=s(e),G=l(e,"DIV",{class:!0});var jt=U(G);m(ve.$$.fragment,jt),Ht=s(jt),Le=l(jt,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-cw9h8a"&&(Le.textContent=Un),jt.forEach(n),Tt=s(e),m(Te.$$.fragment,e),Wt=s(e),P=l(e,"DIV",{class:!0});var N=U(P);m(We.$$.fragment,N),Yt=s(N),Xe=l(N,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-iulkbf"&&(Xe.textContent=$n),zt=s(N),Ne=l(N,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-wu1jmh"&&(Ne.innerHTML=jn),Ft=s(N),I=l(N,"DIV",{class:!0});var qe=U(I);m(xe.$$.fragment,qe),Ot=s(qe),Re=l(qe,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-v78lg8"&&(Re.textContent=kn),Kt=s(qe),m(X.$$.fragment,qe),qe.forEach(n),N.forEach(n),xt=s(e),m(Je.$$.fragment,e),Jt=s(e),m(Pe.$$.fragment,e),Pt=s(e),m(Ce.$$.fragment,e),Ct=s(e),Se=l(e,"P",{}),U(Se).forEach(n),this.h()},h(){x(p,"name","hf:doc:metadata"),x(p,"content",Rn),In(y.src,nn="https://github.com/dome272/Wuerstchen/assets/61938694/0617c863-165a-43ee-9303-2a17299a0cf9")||x(y,"src",nn),In(te.src,un="https://github.com/dome272/Wuerstchen/assets/61938694/2914830f-cbd3-461c-be64-d50734f4b49d")||x(te,"src",un),x(te,"width","500"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,p),o(e,J,t),o(e,M,t),o(e,b,t),f(w,e,t),o(e,r,t),o(e,y,t),o(e,He,t),o(e,R,t),o(e,Ye,t),o(e,Q,t),o(e,ze,t),o(e,q,t),o(e,Fe,t),f(S,e,t),o(e,Oe,t),o(e,H,t),o(e,Ke,t),f(Y,e,t),o(e,et,t),o(e,z,t),o(e,tt,t),o(e,F,t),o(e,nt,t),o(e,O,t),o(e,ot,t),o(e,K,t),o(e,it,t),o(e,ee,t),o(e,st,t),o(e,te,t),o(e,rt,t),f(ne,e,t),o(e,at,t),o(e,oe,t),o(e,lt,t),f(ie,e,t),o(e,ct,t),o(e,se,t),o(e,pt,t),f(re,e,t),o(e,dt,t),f(ae,e,t),o(e,mt,t),o(e,le,t),o(e,ut,t),f(ce,e,t),o(e,ft,t),f(pe,e,t),o(e,ht,t),o(e,de,t),o(e,gt,t),o(e,me,t),o(e,_t,t),f(ue,e,t),o(e,bt,t),o(e,v,t),f(fe,v,null),c(v,kt),c(v,je),c(v,It),c(v,ke),c(v,Gt),c(v,j),f(he,j,null),c(j,Bt),c(j,Ie),c(j,Zt),f(E,j,null),c(v,Vt),c(v,D),f(ge,D,null),c(D,Et),c(D,Ge),c(v,Dt),c(v,A),f(_e,A,null),c(A,At),c(A,Be),o(e,wt,t),f(be,e,t),o(e,Mt,t),o(e,T,t),f(we,T,null),c(T,Lt),c(T,Ze),c(T,Xt),c(T,Ve),c(T,Nt),c(T,Ee),c(T,Rt),c(T,De),c(T,Qt),c(T,k),f(Me,k,null),c(k,qt),c(k,Ae),c(k,St),f(L,k,null),o(e,yt,t),f(ye,e,t),o(e,vt,t),o(e,G,t),f(ve,G,null),c(G,Ht),c(G,Le),o(e,Tt,t),f(Te,e,t),o(e,Wt,t),o(e,P,t),f(We,P,null),c(P,Yt),c(P,Xe),c(P,zt),c(P,Ne),c(P,Ft),c(P,I),f(xe,I,null),c(I,Ot),c(I,Re),c(I,Kt),f(X,I,null),o(e,xt,t),f(Je,e,t),o(e,Jt,t),f(Pe,e,t),o(e,Pt,t),f(Ce,e,t),o(e,Ct,t),o(e,Se,t),Ut=!0},p(e,[t]){const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),E.$set(W);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),L.$set(B);const Ue={};t&2&&(Ue.$$scope={dirty:t,ctx:e}),X.$set(Ue)},i(e){Ut||(h(w.$$.fragment,e),h(S.$$.fragment,e),h(Y.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(ae.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(he.$$.fragment,e),h(E.$$.fragment,e),h(ge.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h(L.$$.fragment,e),h(ye.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),h(We.$$.fragment,e),h(xe.$$.fragment,e),h(X.$$.fragment,e),h(Je.$$.fragment,e),h(Pe.$$.fragment,e),h(Ce.$$.fragment,e),Ut=!0)},o(e){g(w.$$.fragment,e),g(S.$$.fragment,e),g(Y.$$.fragment,e),g(ne.$$.fragment,e),g(ie.$$.fragment,e),g(re.$$.fragment,e),g(ae.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(E.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(Me.$$.fragment,e),g(L.$$.fragment,e),g(ye.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g(We.$$.fragment,e),g(xe.$$.fragment,e),g(X.$$.fragment,e),g(Je.$$.fragment,e),g(Pe.$$.fragment,e),g(Ce.$$.fragment,e),Ut=!1},d(e){e&&(n(J),n(M),n(b),n(r),n(y),n(He),n(R),n(Ye),n(Q),n(ze),n(q),n(Fe),n(Oe),n(H),n(Ke),n(et),n(z),n(tt),n(F),n(nt),n(O),n(ot),n(K),n(it),n(ee),n(st),n(te),n(rt),n(at),n(oe),n(lt),n(ct),n(se),n(pt),n(dt),n(mt),n(le),n(ut),n(ft),n(ht),n(de),n(gt),n(me),n(_t),n(bt),n(v),n(wt),n(Mt),n(T),n(yt),n(vt),n(G),n(Tt),n(Wt),n(P),n(xt),n(Jt),n(Pt),n(Ct),n(Se)),n(p),_(w,e),_(S,e),_(Y,e),_(ne,e),_(ie,e),_(re,e),_(ae,e),_(ce,e),_(pe,e),_(ue,e),_(fe),_(he),_(E),_(ge),_(_e),_(be,e),_(we),_(Me),_(L),_(ye,e),_(ve),_(Te,e),_(We),_(xe),_(X),_(Je,e),_(Pe,e),_(Ce,e)}}}const Rn='{"title":"Würstchen","local":"würstchen","sections":[{"title":"Würstchen Overview","local":"würstchen-overview","sections":[],"depth":2},{"title":"Würstchen v2 comes to Diffusers","local":"würstchen-v2-comes-to-diffusers","sections":[],"depth":2},{"title":"Text-to-Image Generation","local":"text-to-image-generation","sections":[],"depth":2},{"title":"Speed-Up Inference","local":"speed-up-inference","sections":[],"depth":2},{"title":"Limitations","local":"limitations","sections":[],"depth":2},{"title":"WuerstchenCombinedPipeline","local":"diffusers.WuerstchenCombinedPipeline","sections":[],"depth":2},{"title":"WuerstchenPriorPipeline","local":"diffusers.WuerstchenPriorPipeline","sections":[],"depth":2},{"title":"WuerstchenPriorPipelineOutput","local":"diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput","sections":[],"depth":2},{"title":"WuerstchenDecoderPipeline","local":"diffusers.WuerstchenDecoderPipeline","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qn(V){return Bn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class On extends Zn{constructor(p){super(),Vn(this,p,Qn,Nn,Gn,{})}}export{On as component};
